<?php



function insert($table, $fields) {

    global $con;

    $columns = $values = array();

    foreach ($fields as $key => $value) {

        $columns[] = $key;

        $values[] = $value;

    }

    $insert_query = "INSERT INTO $table" . ' (' . implode(',', $columns) . ") VALUES('" . implode("','", $values) . "')";

    query($insert_query);

    return $con->insert_id;

}



function insert_on_duplicate_update($table, $fields) {

    $insert_columns = $values = array();

    $update_columns = '';

    foreach ($fields as $key => $value) {

        $insert_columns[] = $key;

        $values[] = $value;

        if ($key != 'created_on') {

            $update_columns .= $key . "='$value',";

        }

    }

    $insert_query = "INSERT INTO $table" . ' (' . implode(',', $insert_columns) . ") VALUES('" . implode("','", $values) . "')";

    $update_query = "UPDATE " . rtrim($update_columns, ",");



    $insert_on_duplicate_update_query = $insert_query . " ON DUPLICATE KEY " . $update_query . ";";



    query($insert_on_duplicate_update_query);



    return $con->insert_id;

}

function insert_on_duplicate_update_product($table, $fields) {    $insert_columns = $values = array();    $update_columns = '';    foreach ($fields as $key => $value) {        $insert_columns[] = $key;        $values[] = $value;        if ($key != 'created_on') {            $update_columns .= $key . "='$value',";        }    }    $insert_query = "INSERT INTO $table" . ' (' . implode(',', $insert_columns) . ") VALUES('" . implode("','", $values) . "')";    $update_query = "UPDATE " . rtrim($update_columns, ",");    $insert_on_duplicate_update_query = $insert_query . " ON DUPLICATE KEY " . $update_query . ";";    query($insert_on_duplicate_update_query);    return $con->insert_id;}

function update($table, $fields, $where, $limit = NULL) {    $update_query = "UPDATE $table SET ";    $columns = '';    foreach ($fields as $key => $value) {        $columns .= $key . "='$value',";
    }
    $where = prepare_where_condition($where);
    if ($where == '') {
        echo "<pre>update without where condition not allowed</pre>";
        exit;
    }
    $update_query .= rtrim($columns, ",") . " $where ";
    if (isset($limit) && is_numeric($limit) && $limit > 0) {
        $update_query .= "LIMIT $limit";
    }
    $update_query .= " ;";
    return query($update_query);
}function update_without_where($table, $fields, $where=array(), $limit = NULL) {    $update_query = "UPDATE $table SET ";    $columns = '';    foreach ($fields as $key => $value) {        $columns .= $key . "='$value',";    }    $where = prepare_where_condition($where);    if ($where == '') {        echo "<pre>update without where condition not allowed</pre>";        exit;    }    $update_query .= rtrim($columns, ",") ;		if(!empty($where)){	$update_query .=" $where ";	}	    if (isset($limit) && is_numeric($limit) && $limit > 0) {        $update_query .= "LIMIT $limit";    }    $update_query .= " ;";    return query($update_query);}
function delete($table, $where, $limit = NULL) {



    $where = prepare_where_condition($where);



    if ($where == '') {

        echo "<pre>delete without where condition not allowed</pre>";

        exit;

    }



    $delete_query = "DELETE FROM $table $where ";



    if (isset($limit) && is_numeric($limit) && $limit > 0) {

        $delete_query .= "LIMIT $limit";

    }



    $delete_query .= " ;";



    return query($delete_query);

}



function select_row($table, $selected_field = '*', $where = NULL) {



    $where = prepare_where_condition($where);



    $sql = "SELECT " . $selected_field . "  FROM " . $table . " " . $where . " LIMIT 1;";



    $query_resource = query($sql);



    $table_data = array();



    if ($query_resource && $query_resource->num_rows > 0) {

        $table_data = $query_resource->fetch_assoc();
        return $table_data;
    }else{
        return false;       
    }

   

}



function select_result($table, $selected_field = '*', $where = NULL, $orderBy = NULL, $groupBy = NULL, $limit = NULL, $offset = NULL) {



    $where = prepare_where_condition($where);



    $sql = "SELECT " . $selected_field . "  FROM " . $table . " " . $where;



    if (isset($groupBy)) {

        $sql .= " GROUP BY " . $groupBy . " ";

    }

    if (isset($orderBy)) {

        $sql .= " ORDER BY " . $orderBy . " ";

    }

    if (isset($offset) && isset($limit)) {

        $sql .= " LIMIT  " . $offset . "," . $limit;

    }

    if (isset($limit) && !isset($offset)) {

        $sql .= " LIMIT  " . $limit;

    }

    $sql .= ";";


    // var_dump($sql);die;
    $query_resource = query($sql);



    $table_data = array();



    if ($query_resource && $query_resource->num_rows > 0) {

        while ($row = $query_resource->fetch_assoc()) {

            $table_data[] = $row;

        }
        return $table_data;
    }else{
        return false;
    }

   

}



function prepare_where_condition($where_condition) {

    if (!isset($where_condition) || $where_condition == '') {

        $where_condition = '';

    } elseif (is_array($where_condition) && !empty($where_condition)) {

        $where = array();

        foreach ($where_condition as $field => $value) {

            $where[] = "$field='$value'";

        }

        $where_condition = " WHERE " . implode(" AND ", $where);

    } else if (isset($where_condition) && is_string($where_condition)) {

        $where_condition = " WHERE " . $where_condition;

    }

    return $where_condition;

}



function query($query) {

    global $con;

    $query_resource_obj = $con->query($query);

    return $query_resource_obj;

}



function generateRandomString($length = 15, $char_type = 1) {

    $characters = array(

        '1' => '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ',

        '2' => '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ',

        '3' => '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ' . time(),

    );

    $characters_str = $characters[$char_type];

    $charactersLength = strlen($characters_str);

    $randomString = '';

    for ($i = 0; $i < $length; $i++) {

        $randomString .= $characters_str[rand(0, $charactersLength - 1)];

    }

    return $randomString;

}



?>